
#include "320controller.h"
#include "main.h"

/*
 * Hold Status for print
 */
int snowmen[5][10];

/*
 * Function to set each of the snowmen boxes
 */
void set_snowmen(int side, int,int,int,int,int,int,int);

/*
 * These are all the "standard"
 * functions that the snowmen can do
 */
void test_snowmen(void);

void hit_low_right(double pause);
void hit_low_left(double pause);

void hit_high_left(double pause);
void hit_high_right(double pause);

void miss_going_left(double pause);
void miss_going_right(double pause);

void catch_going_left(double pause, double pause2);
void catch_going_right(double pause, double pause2);


/*
 * Box configuration:
 *
 * #1 = Arm Back
 * #2 = Arm Forward
 * #3 = Face
 * #4 = Splash
 * #5 = Ball High
 * #6 = Ball Low
 * #7 = Middle (either high or low)
 */



void *snowmen_main( void *args)
{
  time_t now_t;
  struct tm *now;

  while(1)
  {
    time(&now_t);
    now = localtime(&now_t);
    do_it_snowmen();
  }
}

/*
 *
 * Actually DO the cool stuff
 *
*/

void do_it_snowmen(void)
{
  /********** Testing 
  while(1)
    {
      catch_going_right(.5, .2);
      catch_going_left(.5, .2);
      miss_going_right(.5);
    }
    ********** */
  
  /*********** TESTING2
  while(1)
    {
      
      catch_going_right(.5, .2);
      hit_high_right(.5);
      hit_high_left(.5);
      miss_going_left(.5);
      miss_going_right(.5);
      hit_low_right(.5);
      hit_low_left(.5);
      sleep(2);
    }
    ********** */

  /*
   * Waited (but random) delay between attemps.
   *
   * 38% 2   second sleep
   * 13% 0.2 second sleep
   * 13% 4   second sleep
   * 13% 6   second sleep
   * 25% 1   second sleep
   */

  switch(random() %8)
    {
    case 0:
    case 1:
    case 2:
      sprintf(message2, "Sleep 2");
      sleep(2);
      break;

    case 3:
      sprintf(message2, "Sleep .2");
      write_data(.2);
      break;

    case 4:
      sprintf(message2, "Sleep 4");
      sleep(4);
      break;
      
    case 5:
      sprintf(message2, "Sleep 6");
      sleep(6);
      break;

    case 6:
    case 7:
      sprintf(message2, "Sleep 1");
      sleep(1);
      break;
    }


  /*
   * What function is choosen is also random
   *
   * 14% Hit throwing right (.3 second delay)
   * 14% Hit throwing left (.3 second delay)
   * 14% Miss throwing right (.3 second delay)
   * 14% Miss throwiong left (.3 second dleay)
   * 5%  3 misses right + 5 low hits right
   * 9%  1 miss right + 1 hit right
   * 9%  1 miss left + 1 hit left
   * 5%  3 miss left + 5 low hits left.
   * 5%  miss right, miss left, hit right, hit left
   * 5%  miss rifht, 3 miss left, 5 hit low right
   * 5%  Catch going right
   * 5%  Catch going Left
   */

  switch(random() %22)
    {
    case 0:
    case 1:
    case 2:
      hit_high_right(.3);
      break;
    case 3:
    case 4:
    case 5:
      hit_high_left(.3);
      break;

    case 6:
    case 7:
    case 8:
      miss_going_right(.3);
      break;
      
    case 9:
    case 10:
    case 11:
      miss_going_left(.3);
      break;
      
    case 12:
      miss_going_right(.3);
      miss_going_right(.3);
      miss_going_right(.3);
      hit_low_right(.2);
      hit_low_right(.2);
      hit_low_right(.1);
      hit_low_right(.1);
      hit_low_right(.1);
      break;

    case 13:
    case 14:
      miss_going_right(.3);
      hit_high_right(.3);
      break;

    case 15:
    case 16:
      miss_going_left(.3);
      hit_high_left(.3);
      break;
      
    case 17:
      miss_going_left(.3);
      miss_going_left(.3);
      miss_going_left(.3);
      hit_low_left(.2);
      hit_low_left(.2);
      hit_low_left(.1);
      hit_low_left(.1);
      hit_low_left(.1);
      break;

    case 18:
      miss_going_right(.3);
      miss_going_left(.3);
      hit_high_right(.3);
      hit_high_left(.3);
      break;

    case 19:
      miss_going_right(.3);
      miss_going_left(.3);
      miss_going_left(.3);
      miss_going_left(.3);
      hit_low_right(.2);
      hit_low_right(.2);
      hit_low_right(.2);
      hit_low_right(.1);
      hit_low_right(.1);
      break;

    case 20:
      catch_going_right(.3, .2);
      catch_going_right(.3, .2);
      hit_low_left(.2);
      hit_low_left(.2);
      break;
      
    case 21:
      catch_going_left(.3, .2);
      catch_going_left(.3, .2);
      hit_low_right(.2);
      hit_low_right(.2);
      break;

    }


} /* End: do_it_snowmen */

/*
 * Pattern #1
 *
 */

void hit_low_right(double pause)
{
 
  strcpy(message2, "Hit Low Right");
  /*
   * Clear
   */
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);

  set_snowmen(RIGHT,ON,OFF,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,ON,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,ON,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,ON);
  write_data(pause);


  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,ON,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,ON,OFF,OFF,OFF,OFF);
  write_data(pause * 2);

  
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  
} /* End function hit_low_right */


/*
 * Pattern #5
 *
 */

void hit_high_right(double pause)
{
 
  strcpy(message2, "Hit HIGH Right");
  /*
   * Clear
   */
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);

  set_snowmen(RIGHT,ON,OFF,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,ON,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,ON,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,ON);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);


  set_snowmen(LEFT,OFF,OFF,OFF,OFF,ON,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,ON,OFF,OFF,OFF,OFF);
  write_data(pause * 2);

  
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  
} /* End function hit_high_right */


/*
 * Pattern #8
 *
 */

void catch_going_right(double pause, double pause2)
{
 
  strcpy(message2, "Catch Going Right");
  /*
   * Clear
   */
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);

  set_snowmen(RIGHT,ON,OFF,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,ON,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,ON,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,ON);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);


  set_snowmen(LEFT,OFF,OFF,OFF,OFF,ON,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,ON,OFF,OFF,OFF,OFF,OFF);  /* Catch */
  write_data(pause);

  hit_low_left(pause2);     /* Throw Back */
  
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  
} /* End function hit_high_right */




/*
 * Pattern #2
 *
 */

void hit_low_left(double pause)
{
  strcpy(message2, "Hit Low Left");
  /*
   * Clear
   */
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);

  set_snowmen(LEFT,ON,OFF,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,ON,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,ON,OFF);
  write_data(pause);


  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,ON);
  write_data(pause);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,ON,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,OFF,ON,OFF,OFF,OFF,OFF);
  write_data(pause * 2);

  
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  
} /* End function hit_low_left */




/*
 * Pattern #6
 *
 */

void hit_high_left(double pause)
{
  strcpy(message2, "Hit HIGH Left");
  /*
   * Clear
   */
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);

  set_snowmen(LEFT,ON,OFF,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,ON,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,ON,OFF,OFF);
  write_data(pause);


  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,ON);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,ON,OFF,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,OFF,ON,OFF,OFF,OFF,OFF);
  write_data(pause * 2);

  
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  
} /* End function hit_high_left */



/*
 * Pattern #7
 *
 */

void catch_going_left(double pause, double pause2)
{
  strcpy(message2, "Catch_going_left");
  /*
   * Clear
   */
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);

  set_snowmen(LEFT,ON,OFF,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,ON,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,ON,OFF,OFF);
  write_data(pause);


  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,ON);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,ON,OFF,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,ON,OFF,OFF,OFF,OFF,OFF);  /* Catch */
  write_data(pause);

  hit_low_right(pause2); /* Throw back */

  
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  
} /* End function Catch Going Left */




/*
 * Pattern #3
 *
 */

void miss_going_right(double pause)
{
 
  strcpy(message2, "Miss Going Right");
  /*
   * Clear
   */
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);

  set_snowmen(RIGHT,ON,OFF,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,ON,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,ON,OFF,OFF);
  write_data(pause);

  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,ON);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,ON,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,OFF,ON,OFF,OFF,OFF);
  write_data(pause);

  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  
} /* End function hit_low_right */



/*
 * Pattern #4
 *
 */

void miss_going_left(double pause)
{
 

  strcpy(message2, "Miss Going Left");
  /*
   * Clear
   */
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);

  set_snowmen(LEFT,ON,OFF,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,ON,OFF,OFF,OFF,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,ON,OFF,OFF);
  write_data(pause);
  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,ON);  /* Correct? */
  write_data(pause);

  set_snowmen(LEFT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,ON,OFF);
  write_data(pause);
  set_snowmen(RIGHT,OFF,OFF,OFF,ON,OFF,OFF,OFF);
  write_data(pause * 2);

  
  set_snowmen(RIGHT,OFF,OFF,OFF,OFF,OFF,OFF,OFF);
  
} /* End function hit_low_left */


/*
  Just run some test statuses
*/
void test_snowmen(void)
{
  int j;
  int k;
  int i;

  k = 1;

  for (i=1; i < 3; i++)
  {
    sprintf(message2, "i = %d  Step 1\n", i);
    set_snowmen(i,ON,OFF,OFF,OFF,OFF,OFF,OFF);
    //printf ("%s\n", message2);
    write_data(3);
    sprintf(message2, "i = %d  Step 2\n", i);
    set_snowmen(i,OFF,ON,OFF,OFF,OFF,OFF,OFF);
    //printf ("%s\n", message2);
    write_data(3);
    sprintf(message2, "i = %d  Step 3\n", i);
    set_snowmen(i,OFF,OFF,ON,OFF,OFF,OFF,OFF);
    //printf ("%s\n", message2);
    write_data(3);
    sprintf(message2, "i = %d  Step 4\n", i);
    set_snowmen(i,OFF,OFF,OFF,ON,OFF,OFF,OFF);
    //printf ("%s\n", message2);
    write_data(3);
    sprintf(message2, "i = %d  Step 5\n", i);
    set_snowmen(i,OFF,OFF,OFF,OFF,ON,OFF,OFF);
    //printf ("%s\n", message2);
    write_data(3);
    sprintf(message2, "i = %d  Step 6\n", i);
    set_snowmen(i,OFF,OFF,OFF,OFF,OFF,ON,OFF);
    //printf ("%s\n", message2);
    write_data(3);
    sprintf(message2, "i = %d  Step 7\n", i);
    set_snowmen(i,OFF,OFF,OFF,OFF,OFF,OFF,ON);
    //printf ("%s\n", message2);
    write_data(3);
  }
} /* end test_snowmen */


/*
 * Code to set snowmen for both display
 * as well as upgrade the display boxes
 */
void set_snowmen(int side, int p1, int p2, int p3, int p4,
		           int p5, int p6, int p7)
{ 
  snowmen[side][1] = p1;
  snowmen[side][2] = p2;
  snowmen[side][3] = p3;
  snowmen[side][4] = p4;
  snowmen[side][5] = p5;
  snowmen[side][6] = p6;
  snowmen[side][7] = p7;

  if (side == LEFT)
  {
    boxs[13] = p1 | (p2 * 2) | (p3 * 4) | (p4 * 8) |
      (p5 * 16) | (p6 * 32) | (p7 * 64);
  }
  else
  {
    boxs[12] = p1 | (p2 * 2) | (p3 * 4) | (p4 * 8) |
      (p5 * 16) | (p6 * 32) | (p7 * 64);

  }

}
